-- Sales Invoice Transaction Detail
select * from WideWorldImporters.sales.InvoiceLines where InvoiceID = 2

-- Sales Invoice Transaction
select * from WideWorldImporters.sales.Invoices where InvoiceID = 2

-- Identify Measures - Granularity, Dimensionality
select Quantity, UnitPrice, TaxRate, TaxAmount, LineProfit, ExtendedPrice from WideWorldImporters.sales.InvoiceLines where InvoiceID = 2
select TotalDryItems, TotalChillerItems from WideWorldImporters.sales.Invoices where InvoiceID = 2

-- Fact Invoice
select top 3
	InvoiceID
	, CustomerID
	, InvoiceDate
	, TotalDryItems
	, TotalChillerItems
	, getdate() as createDate
	, 'sreagin' as createdBy
	, getdate() as modifiedDate
	, 'sreagin' as modifiedBy
from
	WideWorldImporters.sales.Invoices

-- Fact Invoice Lines
select top 3
	i.InvoiceID
	, i.CustomerID
	, il.StockItemID
	, i.InvoiceDate
	, il.Quantity
	, il.UnitPrice
	, il.TaxRate
	, il.TaxAmount
	, il.LineProfit
	, il.ExtendedPrice
	, getdate() as createDate
	, 'sreagin' as createdBy
	, getdate() as modifiedDate
	, 'sreagin' as modifiedBy
from
	WideWorldImporters.sales.InvoiceLines il
	inner join WideWorldImporters.Sales.invoices i on
		i.InvoiceID = il.InvoiceID
